//Aim:To design composite high-pass filter.
//Software version Scilab 5.5.2
//OS Windows 7

clear;
clc;
R0=75;//R0 is the nominal impedence (in ohms)
fc=50*(10^3);//fc is the cut-off frequency (in Hz)
f_infinity=48*(10^3);

//Constant k section :
L=R0/(4*%pi*fc);
disp('H',L,'L=')
C=1/(4*%pi*R0*fc);
disp('F',C,'C=')
twoC=2*C;
disp('F',twoC,'2C=')

//m-derived section :

//Computing m
m=sqrt(1-((f_infinity/fc)^2));
disp(m,'m=')
a=(2*C)/m;
disp('F',a,'2C/m=')
b=L/m;
disp('H',b,'L/m=')
c=(4*m*C)/(1-(m^2));
disp('F',c,'(4*m*C)/(1-(m^2))=')

//Matching sections: with m=0.6
//Let us call this new 'm' as m1
m1=0.6;
d=(2*C)/m1;
disp('F',d,'2C/m1=')
e=(2*L)/m1;
disp('H',e,'2L/m1=')
f=(2*m1*C)/(1-(m1^2));
disp('F',f,'(2*m1*C)/(1-(m1^2))=')
//Some of the capacitors will be in series
C1=(d*twoC)/(d+twoC);
disp('F',C1,'C1=')
C2=(twoC*a)/(twoC+a);
disp('F',C2,'C2=')
C3=(a*d)/(a+d);
disp('F',C3,'C3=')
